/***********************************************************
 *
 * d_SDRAM_FLASH_HAL.c
 * SYSTART GmbH
 * MIGA, 20.10.2021
 *
 ***********************************************************/

/***********************************************************
 *
 * @description: This file implements the SDRAM Initialization
 * sequence. This is required to initialize the SDRAM itself,
 * not the FMC. Also it sets all bytes in the SDRAM to 1, to
 * avoid fragments.
 *
 ***********************************************************/

/******************************
 * Includes
 *****************************/
#include "main.h"
#include "driver/d_SDRAM_FLASH_HAL.h"

/***************************
 * Global variable
 **************************/

extern SDRAM_HandleTypeDef hsdram1;

void SDRAM_Initialization_Sequence() {
	FMC_SDRAM_CommandTypeDef FMC_SDRAMCommand;
	uint32_t tmpmrd = 0;
	uint32_t count = 0;

	// Step1: Configure a clock configuration enable command
	FMC_SDRAMCommand.CommandMode = FMC_SDRAM_CMD_CLK_ENABLE;
	FMC_SDRAMCommand.CommandTarget = FMC_SDRAM_CMD_TARGET_BANK1;
	FMC_SDRAMCommand.AutoRefreshNumber = 1;
	FMC_SDRAMCommand.ModeRegisterDefinition = 0;

	while( __FMC_SDRAM_GET_FLAG( hsdram1.Instance, FMC_SDRAM_FLAG_BUSY ) != RESET );
	HAL_SDRAM_SendCommand(&hsdram1, &FMC_SDRAMCommand, 10000);

	// Step2: 100us minimum delay
	for ( count = 0; count < 180000; ++count )
		asm("nop");

	// Step3: Configure PALL command
	FMC_SDRAMCommand.CommandMode = FMC_SDRAM_CMD_PALL;
	FMC_SDRAMCommand.CommandTarget = FMC_SDRAM_CMD_TARGET_BANK1;
	FMC_SDRAMCommand.AutoRefreshNumber = 1;
	FMC_SDRAMCommand.ModeRegisterDefinition = 0;

	while( __FMC_SDRAM_GET_FLAG( hsdram1.Instance, FMC_SDRAM_FLAG_BUSY ) != RESET );
	HAL_SDRAM_SendCommand(&hsdram1, &FMC_SDRAMCommand, 10000);

	// Step4: Configure Auto Refresh command
	FMC_SDRAMCommand.CommandMode = FMC_SDRAM_CMD_AUTOREFRESH_MODE;
	FMC_SDRAMCommand.CommandTarget = FMC_SDRAM_CMD_TARGET_BANK1;
	FMC_SDRAMCommand.AutoRefreshNumber = 8;
	FMC_SDRAMCommand.ModeRegisterDefinition = 0;

	while( __FMC_SDRAM_GET_FLAG( hsdram1.Instance, FMC_SDRAM_FLAG_BUSY ) != RESET );
	HAL_SDRAM_SendCommand(&hsdram1, &FMC_SDRAMCommand, 10000);

	while( __FMC_SDRAM_GET_FLAG( hsdram1.Instance, FMC_SDRAM_FLAG_BUSY ) != RESET );
	HAL_SDRAM_SendCommand(&hsdram1, &FMC_SDRAMCommand, 10000);

	// Step5: Programm external memory mode register
	tmpmrd = (uint32_t) (uint16_t)0x0000 |
			(uint16_t)0x0000   |
			(uint16_t)0x0030           |
			(uint16_t)0x0000 |
			(uint16_t)0x0200;
	FMC_SDRAMCommand.CommandMode = FMC_SDRAM_CMD_LOAD_MODE;
	FMC_SDRAMCommand.CommandTarget = FMC_SDRAM_CMD_TARGET_BANK1;
	FMC_SDRAMCommand.AutoRefreshNumber = 1;
	FMC_SDRAMCommand.ModeRegisterDefinition = tmpmrd;

	while( __FMC_SDRAM_GET_FLAG( hsdram1.Instance, FMC_SDRAM_FLAG_BUSY ) != RESET );
	HAL_SDRAM_SendCommand(&hsdram1, &FMC_SDRAMCommand, 10000);

	FMC_SDRAM_ProgramRefreshRate(hsdram1.Instance, (uint32_t)0x0603);

	while( __FMC_SDRAM_GET_FLAG( hsdram1.Instance, FMC_SDRAM_FLAG_BUSY ) != RESET );

	// Step6: Initialize Memory to ones
	memset((void*) 0xC0000000, 0xFF, (size_t) 0x01000000);
}
