/***********************************************************
 *
 * d_buzzer_HAL.c
 * SYSTART GmbH
 * MIGA, 07.10.2021
 *
 ***********************************************************/

/***********************************************************
 *
 * @description: This file implements the Buzzer functionality
 * of the display board.
 *
 ***********************************************************/

/***********************************************************
 * Includes
 ***********************************************************/
#include "global_Display_Touch_HAL.h"
#include "stm32f4xx_hal_tim.h"
/***********************************************************
 * Extern variables
 ***********************************************************/
extern TIM_HandleTypeDef htim2;

/***********************************************************
 * Function definitions
 ***********************************************************/
void BuzzerON(){
	  HAL_TIM_PWM_Stop(&htim2, TIM_CHANNEL_1);    // stop generation of pwm
	  TIM_OC_InitTypeDef sConfigOC;
	  htim2.Init.Period = 100;           // set the period duration
	  HAL_TIM_PWM_Init(&htim2);  		// reinititialise with new period value

	  sConfigOC.OCMode = TIM_OCMODE_PWM1;
	  sConfigOC.Pulse = 50;              // set the pulse duration
	  sConfigOC.OCPolarity = TIM_OCPOLARITY_HIGH;
	  sConfigOC.OCFastMode = TIM_OCFAST_DISABLE;
	  HAL_TIM_PWM_ConfigChannel(&htim2, &sConfigOC, TIM_CHANNEL_1);

	  HAL_TIM_PWM_Start(&htim2, TIM_CHANNEL_1);   // start pwm generation
}

void BuzzerOFF(){
	HAL_TIM_PWM_Stop(&htim2, TIM_CHANNEL_1);
}
