/***********************************************************
 *
 * TouchUART.c
 * SYSTART GmbH
 * MIGA, 25.10.2021
 *
 ***********************************************************/

/***********************************************************
 * Includes
 ***********************************************************/
#include "application/TouchUART.h"

extern tFont courier_new;
extern UART_HandleTypeDef huart1;
/***********************************************************
 * Function definitions
 ***********************************************************/

void process_touch_input(Buffer_e touchMeBuffer){
	/* Declaration of variables */
  static uint8_t state = RELEASE;
  TouchXY_t* txy;
  static int touch_snd = 0;
  static uint64_t timeout;

	/* Debounce */
  if (touch_snd) {
    if(HAL_GetTick() - timeout > 500)
      return;
    touch_snd = 0;
  }

	/* Get address of touch structure */
  txy = return_touch_struct();
	/* Check for touch event */
  if (txy->event == TOUCH) {
    if (state != TOUCH) {
      state = TOUCH;
      /* Send response via UART */
      send_touch_response(txy);
      touch_snd = 1;
      if(AreaCheck(0, 0, HDP/2, VDP/2)){
        DMA2D_Fill_Color(0xFF00FF00, Layer_1, !touchMeBuffer, true);
        LTDC_Switch_Buffer(!touchMeBuffer);
      }
      else{
        DMA2D_Fill_Color(0xFFFF0000, Layer_1, !touchMeBuffer, true);
        LTDC_Switch_Buffer(!touchMeBuffer);
      }
      timeout = HAL_GetTick();
    }
  }

	/* Check for release event */
  else if (txy->event == RELEASE) {
    if (state != RELEASE) {
      state = RELEASE;
      /* Send response via UART */
      send_touch_response(txy);
      touch_snd = 1;
      timeout = HAL_GetTick();
      LTDC_Switch_Buffer(touchMeBuffer);
    }
  }

	/* Check for error event */
  else if (txy->event == 0xFF) {
  	/* Send response via UART */
    send_touch_response(txy);
    timeout = HAL_GetTick();
  }
}

void send_touch_response(TouchXY_t* touch_resp){
  char output[49];

  if(touch_resp->event == TOUCH){
    sprintf(output, "X,Y-Coordinates: (%3i,%3i) EVENT-TYPE:   TOUCH\r\n", touch_resp->xPos, touch_resp->yPos);
  }
  else if (touch_resp->event == RELEASE){
    sprintf(output, "X,Y-Coordinates: (%3i,%3i) EVENT-TYPE: RELEASE\r\n", touch_resp->xPos, touch_resp->yPos);
  }
  else if (touch_resp->event == 0xFF){
    sprintf(output, "X,Y-Coordinates: (---,---) EVENT-TYPE:   ERROR\r\n");
  }

  HAL_UART_Transmit(&huart1, (uint8_t*) output, (uint16_t) strnlen(output, 49), HAL_MAX_DELAY);

}
