/***********************************************************
 *
 * TouchUART.h
 * SYSTART GmbH
 * MIGA, 25.10.2021
 *
 ***********************************************************/

#ifndef INC_APPLICATION_TOUCHUART_H_
#define INC_APPLICATION_TOUCHUART_H_
/***********************************************************
 * Includes
 ***********************************************************/
#include <stdio.h>
#include <string.h>
#include "global_Display_Touch_HAL.h"
#include "driver/d_Display_DMA2D_HAL.h"
#include "driver/d_Touch_FT5316_ILI2130_HAL.h"

/***********************************************************
 * Defines
 ***********************************************************/


/***********************************************************
 * Function declarations
 ***********************************************************/

/**
* @brief Process the current touch event and display a
* color according to the touch point coordinates.
*
* @param workingBuffer		The display buffer to use
*
*/
void process_touch_input(Buffer_e workingBuffer);

/**
* @brief Send the touch event type and coordinates via UART
*
* @param *touch_resp 			Pointer to the touch event struct
*
*/
void send_touch_response(TouchXY_t* touch_resp);

#endif /* INC_APPLICATION_TOUCHUART_H_ */
