/***********************************************************
 *
 * SDIO.h
 * SYSTART GmbH
 * MIGA, 09.11.2021
 *
 ***********************************************************/

#ifndef INC_APPLICATION_SDIO_H_
#define INC_APPLICATION_SDIO_H_

/***********************************************************
 * Includes
 ***********************************************************/
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include "ff.h"
#include "global_Display_Touch_HAL.h"
#include "driver/d_Display_DMA2D_HAL.h"
#include "libjpeg.h"

/***********************************************************
 * Typedef
 ***********************************************************/
typedef struct {
	uint32_t DirCount;
	uint32_t FilesCount;
	uint8_t JpegCount;
} FATFS_SEARCH_t;


/***********************************************************
 * Function Declaration
 ***********************************************************/

/**
 * brief Search the SD-Card for jpeg files.
 *
 * @param *name_array		pointer to where the name array is stored
 * @return Number of jpegs found
 */
int SDIO_search_for_jpeg(char* name_array);

/**
 * brief: Get the JPEG with name filename from SD-card, decode it, wait if delay is true
 * and draw it on the given display buffer
 *
 * @param *filename			pointer to full filepath to the JPEG which will be drawn
 * @param delay					whether to wait 10 seconds or not
 * @param displaybuffer	which buffer to use for drawing
 */
int paint_JPEG_file (char * filename, bool delay, Buffer_e displayBuffer);


#endif /* INC_APPLICATION_SDIO_H_ */
