/***********************************************************
 *
 * SDIO.c
 * SYSTART GmbH
 * MIGA, 09.11.2021
 *
 ***********************************************************/

/***********************************************************
 * Includes
 ***********************************************************/
#include "application/SDIO.h"

/***********************************************************
* Private Function prototypes
***********************************************************/
static FRESULT scan_files(char* path, uint16_t tmp_buffer_size, FATFS_SEARCH_t* FindStructure, char* tmp_name_array);
FRESULT FATFS_Search(char* dir, char* tmp_buffer, uint32_t tmp_buffer_size, FATFS_SEARCH_t* FindStructure, char* tmp_name_array);
uint8_t is_jpeg(char* fname);
extern LTDC_HandleTypeDef hltdc;

/***********************************************************
* Function definitions
***********************************************************/
int SDIO_search_for_jpeg(char* name_array){
	// check if SD-card is inserted
	if(GPIOG -> IDR & GPIO_PIN_10){
		FRESULT res;
		FATFS sd_fs = {0};
		FATFS_SEARCH_t FindStruct = {0};
		char working_buffer[200];

		//Mount SD card
		res = f_mount(&sd_fs, "0", 1);

		if(res == FR_OK){
			FATFS_Search("/", working_buffer, 50, &FindStruct, name_array);
		}
		f_mount(0, "0", 1);
		return FindStruct.JpegCount;
	}
	else{// no SD-card detected
		return 0;
	}
}


int paint_JPEG_file (char * filename, bool delay, Buffer_e displayBuffer)
{
  struct jpeg_decompress_struct cinfo;
  struct jpeg_error_mgr jerr;

  FIL infile;		// source file
  FATFS sd_fs;
  JSAMPARRAY buffer;		// Output row buffer
  int row_stride;		// physical row width in output buffer
  uint32_t refTime = HAL_GetTick();
  FRESULT fres = f_mount(&sd_fs, "0", 1);
  if(fres != FR_OK){
	  return 1;
  }
  fres = f_open(&infile, filename, FA_READ);
  if (fres != FR_OK) {
    return 1;
  }

  cinfo.err = jpeg_std_error(&jerr);

  jpeg_create_decompress(&cinfo);

  jpeg_stdio_src(&cinfo, &infile);

  jpeg_read_header(&cinfo, TRUE);

  // check if downscaling is needed. If so, set the parameter for decompression accordingly
  if(cinfo.image_width > HDP || cinfo.image_height > VDP){
	  float fract;
	  float width_fract = ((float)HDP)/cinfo.image_width;
	  float height_fract = ((float)VDP)/cinfo.image_height;
	  if(width_fract < height_fract){
		  fract = width_fract;
	  }
	  else{
		  fract = height_fract;
	  }

	  //only supported scaling ratios are M/8 with all M from 1 to 16
	  if(fract >= 7.0/8){
		  cinfo.scale_num = 7;
	  }
	  else if(fract >= 6.0/8){
		  cinfo.scale_num = 6;
	  }
	  else if(fract >= 5.0/8){
		  cinfo.scale_num = 5;
	  }
	  else if(fract >= 4.0/8){
		  cinfo.scale_num = 4;
	  }
	  else if(fract >= 3.0/8){
		  cinfo.scale_num = 3;
	  }
	  else if(fract >= 2.0/8){
		  cinfo.scale_num = 2;
	  }
	  else if(fract >= 1.0/8){
		  cinfo.scale_num = 1;
	  }
	  else{	// jpeg is too large to be shown on this display
		  return 2;
	  }
	  cinfo.scale_denom = 8;
  }

  jpeg_start_decompress(&cinfo);

  row_stride = cinfo.output_width * cinfo.output_components;

  buffer = (*cinfo.mem->alloc_sarray)
		((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);

  int rgb_ctr;
  int pixel_ctr = 0;
  uint32_t pixel = 0;
  uint32_t image_data_addr = 0xC0A00000;
  while (cinfo.output_scanline < cinfo.output_height) {
    jpeg_read_scanlines(&cinfo, buffer, 1);
    rgb_ctr = 0;
    for(int i=0; i<row_stride; i++){
    	uint32_t temp = (uint32_t)*(*buffer+i);
    	switch(rgb_ctr){
    	case 0: pixel = temp<<16;
    			rgb_ctr++;
    			break;
    	case 1: pixel |= temp<<8;
    			rgb_ctr++;
    			break;
    	case 2: pixel |= temp;
    			pixel = (pixel | (0xff << 24));
    			memcpy((void *)image_data_addr+pixel_ctr*4,(void *) &pixel, (size_t) 4);	//4 byte per pixel...
    			pixel_ctr++;
    			rgb_ctr = 0;
    			break;
    	}

    }
  }

  jpeg_finish_decompress(&cinfo);
  jpeg_destroy_decompress(&cinfo);
  f_close(&infile);
  f_mount(0, "0", 1);
  if(delay){
  while(HAL_GetTick()-refTime < 10000){}
  }
  DMA2D_Fill_Color(0xFFFFFFFF, Layer_1, displayBuffer, true);
  DMA2D_Draw_Image((HDP-cinfo.output_width)/2, (VDP-cinfo.output_height)/2, cinfo.output_width, cinfo.output_height,
		  0xFF, DMA2D_REPLACE_ALPHA, (uint32_t)image_data_addr, CM_ARGB8888, Layer_1, displayBuffer, false);

  return 0;
}

/*******************************************************************/
/*                    FATFS PRIVATE FUNCTIONS                      */
/*******************************************************************/
static FRESULT scan_files(char* path, uint16_t tmp_buffer_size, FATFS_SEARCH_t* FindStructure, char* tmp_name_array) {
	FRESULT res;
	FILINFO fno = {0};
	DIR dir = {0};
	int i;
	uint8_t gonext = 1;
	char* fn;
#if _USE_LFN
	static char lfn[_MAX_LFN + 1];   /* Buffer to store the LFN */
	fno.lfname = lfn;
	fno.lfsize = sizeof lfn;
#endif

	/* Try to open file */
	if ((res = f_opendir(&dir, path)) == FR_OK) {
		/* Get length of current path */
		i = strlen(path);

		/* Read item from card */
		while ((res = f_readdir(&dir, &fno)) == FR_OK && fno.fname[0] != 0) {

			/* Ignore files */
			if (fno.fname[0] == '.') {
				continue;
			}

			/* Format name */
	#if _USE_LFN
			fn = *fno.lfname ? fno.lfname : fno.fname;
	#else
			fn = fno.fname;
	#endif

			/* Check if available memory for tmp buffer */
			/* + 1 is for "/" used for path formatting */
			if ((i + strlen(fn) + 1) >= tmp_buffer_size) {
				/* Not enough memory */
				res = FR_NOT_ENOUGH_CORE;

				break;
			}

			/* Format temporary path */
			sprintf(&path[i], "/%s", fn);

			/* Check for folder or file */
			if (fno.fattrib & AM_DIR) {
				/* We are folder */

				/* Increase number of folders */
				FindStructure->DirCount++;

				/* Call user function */
				//gonext = TM_FATFS_SearchCallback(path, 0, FindStructure);	//urspruenglich nicht auskommentiert

				/* Stop execution if user wants that */
				if (gonext) {
					/* Call recursive */
					res = scan_files(path, tmp_buffer_size, FindStructure, tmp_name_array);

					/* Check recursive scan result */
					if (res != FR_OK) {
						break;
					}
				}
			} else {
				/* We are file */

				/* Increase number of files */
				FindStructure->FilesCount++;

				/* Call user function */
				//gonext = TM_FATFS_SearchCallback(path, 1, FindStructure);	//urspruenglich nicht auskommentiert
				if(is_jpeg(path)){
					strcpy((tmp_name_array + FindStructure->JpegCount *50), path);
					FindStructure->JpegCount++;
					//f_closedir(&dir);
					//return res;
				}
			}

			/* Set path back */
			path[i] = 0;

			/* Stop execution if user wants that */
			if (!gonext || res != FR_OK) {
				break;
			}
		}

		/* Close directory */
		f_closedir(&dir);
	}

	/* Return result */
	return res;
}

FRESULT FATFS_Search(char* dir, char* tmp_buffer, uint32_t tmp_buffer_size, FATFS_SEARCH_t* FindStructure, char* tmp_name_array) {
	uint8_t malloc_used = 0;
	FRESULT res;

	/* Reset values first */
	FindStructure->FilesCount = 0;
	FindStructure->DirCount = 0;
	FindStructure->JpegCount = 0;

	/* Check for buffer */
	if (tmp_buffer == NULL) {
		/* Try to allocate memory */
		tmp_buffer = (char *) malloc(tmp_buffer_size);

		/* Check for success */
		if (tmp_buffer == NULL) {
			return FR_NOT_ENOUGH_CORE;
		}
	}

	/* Check if there is a lot of memory allocated */
	if (strlen(dir) < tmp_buffer_size) {
		/* Reset TMP buffer */
		tmp_buffer[0] = 0;

		/* Format path first */
		strcpy(tmp_buffer, dir);

		/* Call search function */
		res = scan_files(tmp_buffer, tmp_buffer_size, FindStructure, tmp_name_array);
	} else {
		/* Not enough memory */
		res = FR_NOT_ENOUGH_CORE;
	}

	/* Check for malloc */
	if (malloc_used) {
		free(tmp_buffer);
	}

	/* Return result */
	return res;
}

uint8_t is_jpeg(char* fname){
	char delimiter[] = ".";
	char tempname[50];	//longest possible file path on SD-card (including file ending) must not exceed 50 characters
	strcpy(tempname, fname);
	char* namepart = strtok(tempname, delimiter);
	namepart = strtok(NULL, delimiter);

	if(!(strcmp(namepart, "JPG") && strcmp(namepart, "JPEG"))){	//strcmp(str1, str2) return 0 if str1==str2
		return (uint8_t) 1;
	}
	else{
		return (uint8_t) 0;
	}
}


