/***********************************************************
 *
 * d_Display_DMA2D_HAL.h
 * SYSTART GmbH
 * JOKI, 26.07.2021
 *
 ***********************************************************/
#ifndef DRIVER_D_DISPLAY_DMA2D_HAL_H_
#define DRIVER_D_DISPLAY_DMA2D_HAL_H_

#include "stm32f4xx_hal.h"
#include "global_Display_Touch_HAL.h"

/***********************************************************
 * Function declarations
************************************************************/

/**
* @brief Initializes display and DMA2D
*
*/
void DMA2D_Display_init();

/**
* @brief Fill whole buffer with a color
*
* @param color 		Color
* @param layer		Layer number (Layer_1, Layer_2)
* @param buffer		Buffer number (Buffer_1, Buffer_2)
*
*/
void DMA2D_Fill_Color(uint32_t color, Layer_e layer, Buffer_e buffer);

/**
* @brief Draw a filled rectangle
*
* @param color		Color of rectangle
* @param xpos 		x-position
* @param ypos 		y-position
* @param width 	Length of rectangle in pixels
* @param height		Height of rectangle in pixels
* @param layer		Layer number (Layer_1, Layer_2)
* @param buffer		Buffer number (Buffer_1, Buffer_2)
*
*/
void DMA2D_Draw_FilledRectangle(uint32_t color, uint16_t xpos, uint16_t ypos, uint16_t width, uint16_t height, Layer_e layer, Buffer_e buffer);

/**
* @brief Fill part of buffer with an image
*
* @param xpos 			x-position
* @param ypos 			y-position
* @param xsize 			Width of image
* @param ysize			Height of image
* @param alpha			Alpha value
* @param alpha_mode		Alpha mode
* @param addr_image 	Address of the image
* @param source_format 	Color format of the image (CM_RGB565, CM_RGB888, ...)
* @param layer			Layer number (Layer_1, Layer_2)
* @param buffer			Buffer number (Buffer_1, Buffer_2)
*
*/
void DMA2D_Draw_Image(uint16_t xpos, uint16_t ypos, uint16_t xsize, uint16_t ysize, uint32_t alpha, uint32_t alpha_mode, uint32_t addr_image, uint32_t source_format, Layer_e layer, Buffer_e buffer);

/**
* @brief Draw text
*
* @param string		Text to be written
* @param xpos 		x-position
* @param ypos 		y-position
* @param color		Font color
* @param font		Font
* @param layer		Layer number (Layer_1, Layer_2) Foreground
* @param buffer		Buffer number (Buffer_1, Buffer_2) Foreground
* @param bglayer	Layer number (Layer_1, Layer_2) Background
* @param bgbuffer	Buffer number (Buffer_1, Buffer_2) Background
* @return Length of string
*/
void DMA2D_write_string(char* string, uint16_t xpos, uint16_t ypos, uint32_t color, tFont* font, Layer_e layer, Buffer_e buffer, Layer_e bglayer, Buffer_e bgbuffer);


#endif /* DRIVER_D_DISPLAY_DMA2D_HAL_H_ */
