
/******************************
 * Includes
 *****************************/
#include "driver/d_Display_DMA2d_HAL.h"

DMA2D_HandleTypeDef hdma2d;
LTDC_LayerCfgTypeDef pLayerCfg = {0};
LTDC_HandleTypeDef hltdc;

/******************************
 * Function definitions
 *****************************/
void DMA2D_Display_init(){

	hltdc.Instance = LTDC;
	hltdc.Init.HSPolarity = HS_POLARITY;
	hltdc.Init.VSPolarity = VS_POLARITY;
	hltdc.Init.DEPolarity = DE_POLARITY;
	hltdc.Init.PCPolarity = PC_POLARITY;
	hltdc.Init.HorizontalSync = HORIZONTAL_SYNC;
	hltdc.Init.VerticalSync = VERTICAL_SYNC;
	hltdc.Init.AccumulatedHBP = ACCUMULATED_HBP;
	hltdc.Init.AccumulatedVBP = ACCUMULATED_VBP;
	hltdc.Init.AccumulatedActiveW = ACCUMULATED_ACTIVE_W;
	hltdc.Init.AccumulatedActiveH = ACCUMULATED_ACTIVE_H;
	hltdc.Init.TotalWidth = TOTAL_WIDTH;
	hltdc.Init.TotalHeigh = TOTAL_HEIGH;
	hltdc.Init.Backcolor.Blue = 255;
	hltdc.Init.Backcolor.Green = 255;
	hltdc.Init.Backcolor.Red = 255;
	if (HAL_LTDC_Init(&hltdc) != HAL_OK)
	{
		//Error_Handler();
	}

	pLayerCfg.WindowX0 = 0;
	pLayerCfg.WindowX1 = LCD_X_PIXEL;
	pLayerCfg.WindowY0 = 0;
	pLayerCfg.WindowY1 = LCD_Y_PIXEL;
	pLayerCfg.PixelFormat = PIXEL_FORMAT;
	pLayerCfg.Alpha = 255;
	pLayerCfg.Alpha0 = 255;
	pLayerCfg.BlendingFactor1 =LTDC_BLENDING_FACTOR1_CA;// LTDC_BLENDING_FACTOR1_PAxCA;
	pLayerCfg.BlendingFactor2 =LTDC_BLENDING_FACTOR2_CA;// LTDC_BLENDING_FACTOR2_PAxCA;
	pLayerCfg.FBStartAdress = LCD_START_ADDR;
	pLayerCfg.ImageWidth = IMAGE_WIDTH;
	pLayerCfg.ImageHeight = IMAGE_HEIGHT;
	pLayerCfg.Backcolor.Blue = 255;
	pLayerCfg.Backcolor.Green = 255;
	pLayerCfg.Backcolor.Red = 255;
	if (HAL_LTDC_ConfigLayer(&hltdc, &pLayerCfg, 0) != HAL_OK)
	{
		//Error_Handler();
	}
}

void DMA2D_Fill_Color(uint32_t color, Layer_e layer, Buffer_e buffer){
	hdma2d.Instance = DMA2D;
	hdma2d.Init.Mode = DMA2D_R2M;
	if(PIXEL_FORMAT == LTDC_PIXEL_FORMAT_RGB565){
		hdma2d.Init.ColorMode = DMA2D_RGB565;
	}
	else if(PIXEL_FORMAT == LTDC_PIXEL_FORMAT_RGB888){
		hdma2d.Init.ColorMode = DMA2D_RGB888;
	}
	else if(PIXEL_FORMAT == LTDC_PIXEL_FORMAT_ARGB8888){
		hdma2d.Init.ColorMode = DMA2D_ARGB8888;
	}

	hdma2d.Init.OutputOffset = 0;

	HAL_DMA2D_DeInit(&hdma2d);
	HAL_DMA2D_Init(&hdma2d);
	HAL_DMA2D_Start(&hdma2d, color, LCD_START_ADDR + LCD_COUNT_BUFFER*layer*LCD_BUFFER_SIZE+buffer*LCD_BUFFER_SIZE, LCD_X_PIXEL, LCD_Y_PIXEL);
	while(hdma2d.Instance->CR & DMA2D_CR_START);
}

void DMA2D_Draw_FilledRectangle(uint32_t color, uint16_t xpos, uint16_t ypos, uint16_t width, uint16_t height, Layer_e layer, Buffer_e buffer){
	hdma2d.Instance = DMA2D;
	hdma2d.Init.Mode = DMA2D_R2M;
	if(PIXEL_FORMAT == LTDC_PIXEL_FORMAT_RGB565){
		hdma2d.Init.ColorMode = DMA2D_RGB565;
	}
	else if(PIXEL_FORMAT == LTDC_PIXEL_FORMAT_RGB888){
		hdma2d.Init.ColorMode = DMA2D_RGB888;
	}
	else if(PIXEL_FORMAT == LTDC_PIXEL_FORMAT_ARGB8888){
		hdma2d.Init.ColorMode = DMA2D_ARGB8888;
	}

	hdma2d.Init.OutputOffset = LCD_X_PIXEL-width;
	HAL_DMA2D_DeInit(&hdma2d);
	HAL_DMA2D_Init(&hdma2d);
	HAL_DMA2D_Start(&hdma2d, color, LCD_START_ADDR+ LCD_COUNT_BUFFER*layer*LCD_BUFFER_SIZE+buffer*LCD_BUFFER_SIZE +xpos*LCD_BPP + ypos*LCD_X_PIXEL*LCD_BPP, width, height);
	HAL_DMA2D_PollForTransfer(&hdma2d, 10);
}

void DMA2D_Draw_Image(uint16_t xpos, uint16_t ypos, uint16_t xsize, uint16_t ysize, uint32_t alpha, uint32_t alpha_mode, uint32_t addr_image, uint32_t source_format, Layer_e layer, Buffer_e buffer){
	if(xpos >= LCD_X_PIXEL || ypos >= LCD_Y_PIXEL) return;

	hdma2d.Instance = DMA2D;
	hdma2d.Init.Mode = DMA2D_M2M_BLEND;
	if(PIXEL_FORMAT == LTDC_PIXEL_FORMAT_RGB565){
		hdma2d.Init.ColorMode = DMA2D_OUTPUT_RGB565;
	}
	else if(PIXEL_FORMAT == LTDC_PIXEL_FORMAT_RGB888){
		hdma2d.Init.ColorMode = DMA2D_OUTPUT_RGB888;
	}
	else if(PIXEL_FORMAT == LTDC_PIXEL_FORMAT_ARGB8888){
		hdma2d.Init.ColorMode = DMA2D_OUTPUT_ARGB8888;
	}
	hdma2d.Init.OutputOffset = LCD_X_PIXEL-xsize;
	hdma2d.LayerCfg[1].InputOffset = 0;
	hdma2d.LayerCfg[1].InputColorMode = source_format;
	hdma2d.LayerCfg[1].AlphaMode = alpha_mode;
	hdma2d.LayerCfg[1].InputAlpha = alpha;

	HAL_DMA2D_DeInit(&hdma2d);
	HAL_DMA2D_Init(&hdma2d);
	HAL_DMA2D_ConfigLayer(&hdma2d, 1);
	HAL_DMA2D_Start(&hdma2d, addr_image, LCD_START_ADDR + LCD_COUNT_BUFFER * layer * LCD_BUFFER_SIZE + buffer * LCD_BUFFER_SIZE + ypos * LCD_X_PIXEL * LCD_BPP + xpos * LCD_BPP, xsize, ysize);
	while(hdma2d.Instance->CR & DMA2D_CR_START);
}

uint16_t DMA2D_write_char(char sign, uint16_t xpos, uint16_t ypos, uint32_t color, tFont* font, Layer_e layer, Buffer_e buffer, Layer_e bglayer, Buffer_e bgbuffer){
	if(xpos >= LCD_X_PIXEL || ypos >= LCD_Y_PIXEL) return 0;
	hdma2d.Instance = DMA2D;
	hdma2d.Init.Mode = DMA2D_M2M_BLEND;
	if(PIXEL_FORMAT == LTDC_PIXEL_FORMAT_RGB565){
		hdma2d.Init.ColorMode = DMA2D_RGB565;
		hdma2d.LayerCfg[0].InputColorMode = DMA2D_INPUT_RGB565;
	}
	else if(PIXEL_FORMAT == LTDC_PIXEL_FORMAT_RGB888){
		hdma2d.Init.ColorMode = DMA2D_RGB888;
		hdma2d.LayerCfg[0].InputColorMode = DMA2D_INPUT_RGB888;
	}
	else if(PIXEL_FORMAT == LTDC_PIXEL_FORMAT_ARGB8888){
		hdma2d.Init.ColorMode = DMA2D_ARGB8888;
		hdma2d.LayerCfg[0].InputColorMode = DMA2D_INPUT_ARGB8888;
	}
	hdma2d.Init.OutputOffset = LCD_X_PIXEL - font->chars[sign - 0x20].image->width;

	hdma2d.LayerCfg[1].InputOffset = 0;
	hdma2d.LayerCfg[1].InputColorMode = DMA2D_INPUT_A8;
	hdma2d.LayerCfg[1].AlphaMode = DMA2D_COMBINE_ALPHA;
	hdma2d.LayerCfg[1].InputAlpha = color;
	hdma2d.LayerCfg[0].InputOffset = LCD_X_PIXEL - font->chars[sign - 0x20].image->width;
	hdma2d.LayerCfg[0].AlphaMode = DMA2D_NO_MODIF_ALPHA;

	HAL_DMA2D_DeInit(&hdma2d);
	HAL_DMA2D_Init(&hdma2d);
	HAL_DMA2D_ConfigLayer(&hdma2d, 1);
	HAL_DMA2D_ConfigLayer(&hdma2d, 0);
	HAL_DMA2D_BlendingStart(&hdma2d, (uint32_t)font->chars[sign-0x20].image->data, LCD_START_ADDR + LCD_COUNT_BUFFER * layer * LCD_BUFFER_SIZE + buffer * LCD_BUFFER_SIZE + ypos * LCD_X_PIXEL * LCD_BPP + xpos * LCD_BPP,
			LCD_START_ADDR + LCD_COUNT_BUFFER * bglayer * LCD_BUFFER_SIZE + bgbuffer * LCD_BUFFER_SIZE + ypos * LCD_X_PIXEL * LCD_BPP + xpos * LCD_BPP, font->chars[sign - 0x20].image->width, font->chars[sign - 0x20].image->height);
	while(hdma2d.Instance->CR & DMA2D_CR_START);

	return font->chars[sign- 0x20].image->width;
}

void DMA2D_write_string(char* string, uint16_t xpos, uint16_t ypos, uint32_t color, tFont* font, Layer_e layer, Buffer_e buffer, Layer_e bglayer, Buffer_e bgbuffer){
	uint16_t x_offset = 0, x_add;
	while(*string != '\0'){
		x_add = DMA2D_write_char(*string, xpos + x_offset, ypos, color, font, layer, buffer, bglayer, bgbuffer);
		if(x_add < 0) return;
		x_offset += x_add;
		string++;
	}
}
