
#include "stm32f4xx_hal.h"

/***************************
 * Global variable
 **************************/
SDRAM_HandleTypeDef hsdram1;

/*********************************
 * Declaration internal function
*********************************/
void SDRAM_Initialization_Sequence();

/*****************************
 * Function definitions
 ****************************/
void SDRAM_FLASH_init(){
	FMC_SDRAM_TimingTypeDef SdramTiming = {0};

	/** Perform the SDRAM1 memory initialization sequence
	*/
	hsdram1.Instance = FMC_SDRAM_DEVICE;
	/* hsdram1.Init */
	hsdram1.Init.SDBank = FMC_SDRAM_BANK1;
	hsdram1.Init.ColumnBitsNumber = FMC_SDRAM_COLUMN_BITS_NUM_8;
	hsdram1.Init.RowBitsNumber = FMC_SDRAM_ROW_BITS_NUM_12;
	hsdram1.Init.MemoryDataWidth = FMC_SDRAM_MEM_BUS_WIDTH_32;
	hsdram1.Init.InternalBankNumber = FMC_SDRAM_INTERN_BANKS_NUM_4;
	hsdram1.Init.CASLatency = FMC_SDRAM_CAS_LATENCY_3;
	hsdram1.Init.WriteProtection = FMC_SDRAM_WRITE_PROTECTION_DISABLE;
	hsdram1.Init.SDClockPeriod = FMC_SDRAM_CLOCK_PERIOD_2;
	hsdram1.Init.ReadBurst = FMC_SDRAM_RBURST_ENABLE;
	hsdram1.Init.ReadPipeDelay = FMC_SDRAM_RPIPE_DELAY_0;
	/* SdramTiming */
	SdramTiming.LoadToActiveDelay = 2;
	SdramTiming.ExitSelfRefreshDelay = 6;
	SdramTiming.SelfRefreshTime = 4;
	SdramTiming.RowCycleDelay = 6;
	SdramTiming.WriteRecoveryTime = 2;
	SdramTiming.RPDelay = 2;
	SdramTiming.RCDDelay = 2;

	if (HAL_SDRAM_Init(&hsdram1, &SdramTiming) != HAL_OK)
	{
		//Error_Handler( );
	}

	SDRAM_Initialization_Sequence();
}


/*********************************
 * Definitions internal function
*********************************/
void SDRAM_Initialization_Sequence( void )
{
	FMC_SDRAM_CommandTypeDef FMC_SDRAMCommand;
	uint32_t tmpmrd = 0;
	uint32_t count = 0;

	// Step1: Configure a clock configuration enable command
	FMC_SDRAMCommand.CommandMode = FMC_SDRAM_CMD_CLK_ENABLE;
	FMC_SDRAMCommand.CommandTarget = FMC_SDRAM_CMD_TARGET_BANK1;
	FMC_SDRAMCommand.AutoRefreshNumber = 1;
	FMC_SDRAMCommand.ModeRegisterDefinition = 0;

	while( __FMC_SDRAM_GET_FLAG( hsdram1.Instance, FMC_SDRAM_FLAG_BUSY ) != RESET );
	HAL_SDRAM_SendCommand(&hsdram1, &FMC_SDRAMCommand, 10000);

	// Step2: 100us minimum delay
	for ( count = 0; count < 180000; ++count )
		asm("nop");

	// Step3: Configure PALL command
	FMC_SDRAMCommand.CommandMode = FMC_SDRAM_CMD_PALL;
	FMC_SDRAMCommand.CommandTarget = FMC_SDRAM_CMD_TARGET_BANK1;
	FMC_SDRAMCommand.AutoRefreshNumber = 1;
	FMC_SDRAMCommand.ModeRegisterDefinition = 0;

	while( __FMC_SDRAM_GET_FLAG( hsdram1.Instance, FMC_SDRAM_FLAG_BUSY ) != RESET );
	HAL_SDRAM_SendCommand(&hsdram1, &FMC_SDRAMCommand, 10000);

	// Step4: Configure Auto Refresh command
	FMC_SDRAMCommand.CommandMode = FMC_SDRAM_CMD_AUTOREFRESH_MODE;
	FMC_SDRAMCommand.CommandTarget = FMC_SDRAM_CMD_TARGET_BANK1;
	FMC_SDRAMCommand.AutoRefreshNumber = 8;
	FMC_SDRAMCommand.ModeRegisterDefinition = 0;

	while( __FMC_SDRAM_GET_FLAG( hsdram1.Instance, FMC_SDRAM_FLAG_BUSY ) != RESET );
	HAL_SDRAM_SendCommand(&hsdram1, &FMC_SDRAMCommand, 10000);

	while( __FMC_SDRAM_GET_FLAG( hsdram1.Instance, FMC_SDRAM_FLAG_BUSY ) != RESET );
	HAL_SDRAM_SendCommand(&hsdram1, &FMC_SDRAMCommand, 10000);

	// Step5: Programm external memory mode register
	tmpmrd = (uint32_t) (uint16_t)0x0000 |
			(uint16_t)0x0000   |
			(uint16_t)0x0030           |
			(uint16_t)0x0000 |
			(uint16_t)0x0200;
	FMC_SDRAMCommand.CommandMode = FMC_SDRAM_CMD_LOAD_MODE;
	FMC_SDRAMCommand.CommandTarget = FMC_SDRAM_CMD_TARGET_BANK1;
	FMC_SDRAMCommand.AutoRefreshNumber = 1;
	FMC_SDRAMCommand.ModeRegisterDefinition = tmpmrd;

	while( __FMC_SDRAM_GET_FLAG( hsdram1.Instance, FMC_SDRAM_FLAG_BUSY ) != RESET );
	HAL_SDRAM_SendCommand(&hsdram1, &FMC_SDRAMCommand, 10000);

	FMC_SDRAM_ProgramRefreshRate(hsdram1.Instance, (uint32_t)0x0603);

	while( __FMC_SDRAM_GET_FLAG( hsdram1.Instance, FMC_SDRAM_FLAG_BUSY ) != RESET );
}
