/*****************************************************************
 *  File: weather_interface.c
 *
 *  Summary: Functions to draw the weather_interface
 *
 ****************************************************************/
#include "application/weather_interface.h"
#include "driver/d_Display_DMA2D_HAL.h"

extern tImage Y21Display;
extern tImage Display21_Logo_Y_43Inch;
extern tFont courier_new_23;
extern tFont courier_new_15;
extern tFont courier_new_14;
extern tFont arial_56_deg;
extern tFont arial_56;
extern tFont arial_28_deg;

/***********************************************************
 * Function definitions
 ***********************************************************/

/*****************************************************************
 *
 * Function: void draw_weather_interface(char* ip_addr, Buffer_e nextBuffer)
 *
 * Summary: Draws the background for the weather station on the given
 * display buffer
 *
 * Parameters:
 *
 * Return:
 *
 * Revision History:
 * Creation Date: 28062021
 *
 *****************************************************************/
void draw_weather_interface(char* ip_addr, Buffer_e nextBuffer){
#ifdef DISPLAY_5_INCH
	/* Buffer_1 */
  DMA2D_Fill_Color(0xFFFF, Layer_1, nextBuffer, false);
  DMA2D_Fill_Color(0x7FFF, Layer_2, nextBuffer, false);
  DMA2D_Draw_Image((HDP-Y21Display.width)/2, (VDP-Y21Display.height)/2, Y21Display.width, Y21Display.height,
      0x7F, DMA2D_REPLACE_ALPHA, (uint32_t)Y21Display.data, CM_ARGB8888, Layer_1, nextBuffer, false);
  //temperature box
  DMA2D_Draw_Rectangle(0, 0, HDP*2/5, VDP/2, 0xCF07, 6, Layer_1, nextBuffer);
  DMA2D_write_string("Temperature:", 10, 15, 0x8000, &courier_new_23, Layer_1, nextBuffer, false);
  //humidity box
  DMA2D_Draw_Rectangle(0, VDP/2-3, HDP*2/5, VDP/2 -27, 0xCF07, 6, Layer_1, nextBuffer);
  DMA2D_write_string("Humidity:", 10, VDP/2 +15, 0x8000, &courier_new_23, Layer_1, nextBuffer, false);
  //pressure box
  DMA2D_Draw_Rectangle(HDP*2/5-3, 0, HDP*3/5+3, VDP*2/3, 0xCF07, 6, Layer_1, nextBuffer);
  DMA2D_write_string("Pressure:", HDP*2/5 +10, 15, 0x8000, &courier_new_23, Layer_1, nextBuffer, false);
  DMA2D_write_string("approx. Altitude:", HDP*2/5 +30, VDP/2, 0x8000, &courier_new_15, Layer_1, nextBuffer, false);
  //gas resistance box
  DMA2D_Draw_Rectangle(HDP*2/5-3, VDP*2/3-3, HDP*3/5+3, VDP*1/3 -27, 0xCF07, 6, Layer_1, nextBuffer);
  DMA2D_write_string("Gas Resistance:", HDP*2/5 +10, VDP*2/3 +15, 0x8000, &courier_new_23, Layer_1, nextBuffer, false);

  //IP-Address
  DMA2D_write_string("IP:", 10, VDP-28, 0x8000, &courier_new_15, Layer_1, nextBuffer, false);
  DMA2D_write_string(ip_addr, 50, VDP-28, 0x8000, &courier_new_15, Layer_1, nextBuffer, false);
#endif
#ifdef DISPLAY_4_3_INCH
	/* Buffer_1 */
  DMA2D_Fill_Color(0xFFFF, Layer_1, nextBuffer, false);
  DMA2D_Fill_Color(0x7FFF, Layer_2, nextBuffer, false);
	DMA2D_Draw_Image((HDP-Display21_Logo_Y_43Inch.width)/2, (VDP-Display21_Logo_Y_43Inch.height)/2, Display21_Logo_Y_43Inch.width, Display21_Logo_Y_43Inch.height,
			0x7F, DMA2D_REPLACE_ALPHA, (uint32_t)Display21_Logo_Y_43Inch.data, CM_RGB565, Layer_1, nextBuffer, false);
	//temperature box
	DMA2D_Draw_Rectangle(0, 0, HDP*2/5, VDP/2 - 10, 0xCF07, 6, Layer_1, nextBuffer);
	DMA2D_write_string("Temperature:", 10, 15, 0x8000, &courier_new_15, Layer_1, nextBuffer, false);
	//humidity box
	DMA2D_Draw_Rectangle(0, VDP/2-3-10, HDP*2/5, VDP/2 -27+10, 0xCF07, 6, Layer_1, nextBuffer);
	DMA2D_write_string("Humidity:", 10, VDP/2 - 10 +15, 0x8000, &courier_new_15, Layer_1, nextBuffer, false);
	//pressure box
	DMA2D_Draw_Rectangle(HDP*2/5-3, 0, HDP*3/5+3, VDP*2/3 - 20, 0xCF07, 6, Layer_1, nextBuffer);
	DMA2D_write_string("Pressure:", HDP*2/5 +10, 15, 0x8000, &courier_new_15, Layer_1, nextBuffer, false);
	DMA2D_write_string("approx. Altitude:", HDP*2/5 +30, VDP/2-20, 0x8000, &courier_new_14, Layer_1, nextBuffer, false);
	//gas resistance box
	DMA2D_Draw_Rectangle(HDP*2/5-3, VDP*2/3-3-20, HDP*3/5+3, VDP*1/3 -27+20, 0xCF07, 6, Layer_1, nextBuffer);
	DMA2D_write_string("Gas Resistance:", HDP*2/5 +10, VDP*2/3 +15-20, 0x8000, &courier_new_15, Layer_1, nextBuffer, false);

	//IP-Address
	DMA2D_write_string("IP:", 10, VDP-28, 0x8000, &courier_new_15, Layer_1, nextBuffer, false);
	DMA2D_write_string(ip_addr, 50, VDP-28, 0x8000, &courier_new_15, Layer_1, nextBuffer, false);
#endif
}

/*****************************************************************
 *
 * Function: draw_weather_data(weather_data_struct w_data, Buffer_e nextBuffer)
 *
 * Summary: Draws the values retrieved from the ESP32 on the given display
 * buffer.
 *
 * Parameters: -
 *
 *
 * Return: -
 *
 * Revision History:
 * Creation Date: 28062021
 *
 *****************************************************************/
void draw_weather_data(weather_data_struct w_data, Buffer_e nextBuffer){
  char temp[12] = {0};
#ifdef DISPLAY_5_INCH
  //temperature
  sprintf(temp, "%4.2f %cC", w_data.temperature, 0x7f);
  DMA2D_Draw_FilledRectangle(0x7FFF, 20, VDP*1/8, HDP*2/5-50, VDP*2/8, Layer_2, nextBuffer, true);
  DMA2D_write_string(temp, HDP/5 -25*4, VDP/5, 0x8000, &arial_56_deg, Layer_2, nextBuffer, true);

  //humidity
  sprintf(temp, "%2.0f %%", w_data.humidity);
  DMA2D_Draw_FilledRectangle(0x7FFF, 20, VDP*5/8, HDP*2/5-50, VDP*2/8, Layer_2, nextBuffer, true);
  DMA2D_write_string(temp, HDP/5 -arial_56.chars->image->width*2, VDP*2/3, 0x8000, &arial_56, Layer_2, nextBuffer, true);

  //pressure
  sprintf(temp, "%6.2f hPa", w_data.pressure);
  DMA2D_Draw_FilledRectangle(0x7FFF, HDP*2/5+20, VDP/5, HDP*3/5-50, VDP*1/6, Layer_2, nextBuffer, true);
  DMA2D_write_string(temp, HDP*7/10 -arial_56.chars->image->width*6, VDP/5, 0x8000, &arial_56, Layer_2, nextBuffer, true);

  //approx altitude
  sprintf(temp, "%3.0f m", w_data.approx_altitude);
  DMA2D_Draw_FilledRectangle(0x7FFF, HDP*2/5+20+13*20, VDP/2-10, HDP/4-10, VDP/6-5, Layer_2, nextBuffer, true);
  DMA2D_write_string(temp, HDP*2/5 +30+13*20, VDP/2, 0x8000, &courier_new_23, Layer_2, nextBuffer, true);

  //gas resistance
  sprintf(temp, "%5.2f kOhm", w_data.gas_resistance);
  DMA2D_Draw_FilledRectangle(0x7FFF, HDP*2/5+20, VDP*9/12, HDP*2/5, VDP*1/6, Layer_2, nextBuffer, true);
  DMA2D_write_string(temp, HDP*7/10 -courier_new_23.chars->image->width*6, VDP*3/4+30, 0x8000, &courier_new_23,
      Layer_2, nextBuffer, true);
#endif
#ifdef DISPLAY_4_3_INCH
  //temperature
  sprintf(temp, "%4.2f %cC", w_data.temperature, 0x7f);
  DMA2D_Draw_FilledRectangle(0x7FFF, 20, VDP*1/8, HDP*2/5-50, VDP*2/8, Layer_2, nextBuffer, true);
  DMA2D_write_string(temp, HDP/5 -arial_28_deg.chars->image->width*7, VDP/5, 0x8000, &arial_28_deg, Layer_2, nextBuffer, true);

  //humidity
  sprintf(temp, "%2.0f %%", w_data.humidity);
  DMA2D_Draw_FilledRectangle(0x7FFF, 20, VDP*5/8, HDP*2/5-50, VDP*2/8, Layer_2, nextBuffer, true);
  DMA2D_write_string(temp, HDP/5 -arial_28_deg.chars->image->width*2, VDP*2/3, 0x8000, &arial_28_deg, Layer_2, nextBuffer, true);

  //pressure
  sprintf(temp, "%6.2f hPa", w_data.pressure);
  DMA2D_Draw_FilledRectangle(0x7FFF, HDP*2/5+20, VDP/5, HDP*3/5-50, VDP*1/6, Layer_2, nextBuffer, true);
  DMA2D_write_string(temp, HDP*7/10 -arial_28_deg.chars->image->width*6, VDP/5, 0x8000, &arial_28_deg, Layer_2, nextBuffer, true);

  //approx altitude
  sprintf(temp, "%3.0f m", w_data.approx_altitude);
  DMA2D_Draw_FilledRectangle(0x7FFF, HDP*3/4, VDP/2-20, HDP/4-10, VDP/6-5, Layer_2, nextBuffer, true);
  DMA2D_write_string(temp, HDP*2/5 +courier_new_15.chars->image->width*13, VDP/2 -20, 0x8000, &courier_new_15, Layer_2, nextBuffer, true);

  //gas resistance
  sprintf(temp, "%5.2f kOhm", w_data.gas_resistance);
  DMA2D_Draw_FilledRectangle(0x7FFF, HDP*2/5+20, VDP*9/12, HDP*2/5, VDP*1/6, Layer_2, nextBuffer, true);
  DMA2D_write_string(temp, HDP*7/10 -courier_new_15.chars->image->width*6, VDP*3/4+30-25, 0x8000, &courier_new_15,
  		Layer_2, nextBuffer, true);
#endif
}
