/*****************************************************************
 *  File: uart_esp32_comm.c
 *
 *  Summary: Functions to send, receive and parse uart data
 *
 ****************************************************************/
#ifndef UART_esp32_COMM_H_
#define UART_esp32_COMM_H_
/***********************************************************
 * Includes
 ***********************************************************/
#include <stdbool.h>
#include "application/weather_interface.h"
/***********************************************************
 * Defines
 ***********************************************************/
#define PROTOCOL_VERSION 0

#define UART_ENDIANNESS LITTLE_ENDIAN

#define RCV_START_BYTE 0xF1
#define RCV_STOP_BYTE 0xF4
#define SND_START_BYTE 0xF2
#define SND_STOP_BYTE 0xF8

#define NUM_CMD 55
#define MAX_TEXT_LEN 100

/***********************************************************
 * Typedefs and Enums
 ***********************************************************/

typedef enum{
	CHECK_CONNECTION = 0,
	GET_ALL,
	GET_TEMPERATURE,
	GET_HUMIDITY,
	GET_PRESSURE,
	GET_APPROX_ALTITUDE,
	GET_GAS_RESISTANCE,
	GET_IP_ADDRESS
}esp32_cmd;


/***********************************************************
 *Public Function Prototypes
************************************************************/
HAL_StatusTypeDef get_all_data_esp32(weather_data_struct* w_data);
//comm_err_t get_data_esp32(weather_data_struct* w_data);
//comm_err_t get_temperature_esp32(weather_data_struct* w_data);
//comm_err_t check_communication_esp32(void);
void get_ip_address_esp32(weather_data_struct* w_data);

#endif /* UART_ESP32_COMM_H_ */
