/*****************************************************************
 *  File: uart_rs232_comm.c
 *
 *  Summary: Functions to send, receive and parse uart data
 *
 ****************************************************************/

/***********************************************************
 * Includes
 ***********************************************************/
#include <application/uart_esp32_comm.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "driver/d_Display_DMA2D_HAL.h"
#include "driver/d_UART_HAL.h"

union float_bytes_union{
  uint8_t bytes[4];
  float floatVal;
};

static union float_bytes_union float_bytes;
extern UART_HandleTypeDef huart3;

/***********************************************************
 * Function definitions
 ***********************************************************/

/*****************************************************************
 *
 * Function: HAL_StatusTypeDef get_all_data_esp32(weather_data_struct* w_data)
 *
 * Summary: Get all data from esp32 and the sensor
 *
 * Parameters:
 *     w_data* Pointer to the weatherdata-struct, which will be filled
 *     with the data
 *
 * Return:
 *  0 - if success
 *
 * Revision History:
 * Creation Date: 28062021
 *
 *****************************************************************/
HAL_StatusTypeDef get_all_data_esp32(weather_data_struct* w_data) {

	HAL_StatusTypeDef ret;
	uint8_t buf[4];
	uint8_t cmd = 1;
	memset(buf,0,4);

	/* Reset ringbuffer to recv new data */
	reset_ringbuffer(COM3);
	ret = HAL_UART_Transmit(&huart3, &cmd, 1, 100);
	if(ret != HAL_OK)
		return ret;
	/* Wait shortly for Interrupt filling the buffer */
	HAL_Delay(200);
	uart_Receive4Byte(COM3, buf, BIG_ENDIAN_T);
	float_bytes.bytes[0]=buf[0];
	float_bytes.bytes[1]=buf[1];
	float_bytes.bytes[2]=buf[2];
	float_bytes.bytes[3]=buf[3];
	w_data->temperature = float_bytes.floatVal;
	uart_Receive4Byte(COM3, buf, BIG_ENDIAN_T);
	float_bytes.bytes[0]=buf[0];
	float_bytes.bytes[1]=buf[1];
	float_bytes.bytes[2]=buf[2];
	float_bytes.bytes[3]=buf[3];
	w_data->humidity = float_bytes.floatVal;
	uart_Receive4Byte(COM3, buf, BIG_ENDIAN_T);
	float_bytes.bytes[0]=buf[0];
	float_bytes.bytes[1]=buf[1];
	float_bytes.bytes[2]=buf[2];
	float_bytes.bytes[3]=buf[3];
	w_data->pressure = float_bytes.floatVal;
	uart_Receive4Byte(COM3, buf, BIG_ENDIAN_T);
	float_bytes.bytes[0]=buf[0];
	float_bytes.bytes[1]=buf[1];
	float_bytes.bytes[2]=buf[2];
	float_bytes.bytes[3]=buf[3];
	w_data->approx_altitude = float_bytes.floatVal;
	uart_Receive4Byte(COM3, buf, BIG_ENDIAN_T);
	float_bytes.bytes[0]=buf[0];
	float_bytes.bytes[1]=buf[1];
	float_bytes.bytes[2]=buf[2];
	float_bytes.bytes[3]=buf[3];
	w_data->gas_resistance = float_bytes.floatVal;

	return HAL_OK;
}

/*****************************************************************
 *
 * Function: void get_ip_address_esp32(weather_data_struct* w_data)
 *
 * Summary: Retrieves the IP-Address for the weather-station-webpage from the ESP32
 *
 * Parameters:
 *		w_data* - pointer to the weatherdata-struct which is gonna be filled
 *		with the ip adress
 *
 * Return: -
 *
 * Revision History:
 * Creation Date: 28062021
 *
 *****************************************************************/
void get_ip_address_esp32(weather_data_struct* w_data){
	char ip_string[16];
	reset_ringbuffer(COM3);
	uart_SendByte(COM3, GET_IP_ADDRESS);

	HAL_Delay(500);

	uart_ReceiveString(COM3, ip_string);

	memcpy(w_data->ip_address, ip_string, 16);
}
