/***********************************************************
 *
 * d_rigado_bmd300.h
 * SYSTART GmbH
 * FLB, 09.05.2017
 *
 ***********************************************************/

#ifndef D_RIGADO_BMD300_H_
#define D_RIGADO_BMD300_H_

/***********************************************************
 * Includes
 ***********************************************************/
#include "stm32f4xx.h"
#include "driver/d_UART_HAL.h"


/***********************************************************
 * Enums
 ***********************************************************/
//Enums Rigado BMD-300
typedef enum{
	RIGADO_ACTIVE,
	RIGADO_INACTIVE,
	RIGADO_NOT_ASKED
}RIGADO_STATUS_e;

/***********************************************************
 * Structs
 ***********************************************************/
struct string_props{
	uint32_t color;
	uint16_t xpos;
	uint16_t ypos;
};


void Rigado_BMD_300_init( void );
void Rigado_BMD_300_SendBytes ( uint32_t count, uint8_t* data );
void Rigado_BMD_300_SendString ( uint8_t* data );
void Rigado_BMD_300_get_string(uint8_t* rx_temp);
void Rigado_BMD_300_SendByte ( uint8_t data );
RIGADO_STATUS_e Rigado_BMD_300_get_status(void);

void string_props_init(struct string_props *sp);
void process_font_command(struct string_props *sp, char* string);

#endif /* D_RIGADO_BMD300_H_ */
