/***********************************************************
 *
 * d_Touch_FT5316_ILI2130_HAL.h
 * SYSTART GmbH
 * MIGA, 07.10.2021
 *
 ***********************************************************/

#ifndef __D_TOUCH_FT5316_ILI2130_HAL_H_
#define __D_TOUCH_FT5316_ILI2130_HAL_H_

/***********************************************************
 * Includes
 ***********************************************************/
#include <stdbool.h>
#include "main.h"
#include "global_Display_Touch_HAL.h"

/***********************************************************
 * Defines
 ***********************************************************/
#define TOUCH 0x02
#define RELEASE 0x01

/***********************************************************
 * Function declarations
 ***********************************************************/

/**
* @brief Poll the touch panel and get response through I2C
* Look at d_Touch_FT5316_ILI2130_HAL.c header for detailed
* information. This function is usually called by an ISR.
*/
void retrieve_touch_points();

/**
* @brief Returns the pointer to the global TouchXY_t structure.
* @return Pointer to global touch struct
*/
TouchXY_t* return_touch_struct();

/**
* @brief Checks if last touch event was in provided area.
* @param X-Value of left side of the area
* @param Y-Value of top side of the area
* @param X-Value of right side of the area
* @param Y-Value of bottom side of the area
* @return Boolean value of area check
*/
bool AreaCheck ( uint16_t LeftX, uint16_t TopY, uint16_t RightX, uint16_t BottomY );

#endif // __D_TOUCH_FT5316_ILI2130_HAL_H_
