/***********************************************************
 *
 * global_Display_Touch_HAL.h
 * SYSTART GmbH
 * JOKI, 26.07.2021
 *
 ***********************************************************/

#ifndef __GLOBAL_DISPLAY_TOUCH_H_
#define __GLOBAL_DISPLAY_TOUCH_H_

#include "driver/d_Fonts.h"
/***********************************************************
 * Defines
 ***********************************************************/
#define DISPLAY_5_INCH

// ***************    Defines for debugging    *****************
#define DBG_DISPLAY				1		// comment this out to work without "large images"


typedef struct {
	uint16_t xPos;				// X-Position
	uint16_t yPos;				// Y-Position
	uint8_t event;
}TouchXY_t;

typedef int16_t Gesture_ID_e;

typedef enum
{
	Layer_1 = 0,
	Layer_2
}Layer_e;

typedef enum{
	Buffer_1 = 0,
	Buffer_2
}Buffer_e;

// ***************    Defines for display driver    *****************
// Values from display datasheet

// 5 inch display
#ifdef DISPLAY_5_INCH
	#define BACKLIGHT_EN 	1				// Init backlight
	#define HDP				800				// Horizontal Display Period
	#define HBP				62				// Horizontal Back Porch
	#define HFP				62				// Horizontal Front Porch
	#define HPW				1				// Horizontal Pulse Width
	#define VDP				480				// Vertical Display Period
	#define VBP				45				// Vertical Back Porch
	#define VFP				45				// Vertical Front Porch
	#define VPW				10				// Vertical Pulse Width
	#define DE_POLARITY		LTDC_DEPOLARITY_AL
	#define PC_POLARITY		LTDC_PCPOLARITY_IPC
#endif


// 4.3 inch display
#ifdef DISPLAY_4_3_INCH
	#define BACKLIGHT_EN	0				// Init backlight not needed
	#define HDP				480				// Horizontal Display Period
	#define HBP				43				// Horizontal Back Porch
	#define HFP				8				// Horizontal Front Porch
	#define HPW				4				// Horizontal Pulse Width
	#define VDP				272				// Vertical Display Period
	#define VBP				12				// Vertical Back Porch
	#define VFP				8				// Vertical Front Porch
	#define VPW				4				// Vertical Pulse Width
	#define DE_POLARITY		LTDC_DEPOLARITY_AH
	#define PC_POLARITY		LTDC_PCPOLARITY_IPC
#endif


// 3.5 inch display
#ifdef DISPLAY_3_5_INCH
	#define BACKLIGHT_EN 	1				// Init backlight
	#define HDP				320				// Horizontal Display Period
	#define HBP				38				// Horizontal Back Porch
	#define HFP				20				// Horizontal Front Porch
	#define HPW				30				// Horizontal Pulse Width
	#define VDP				240				// Vertical Display Period
	#define VBP				15				// Vertical Back Porch
	#define VFP		        4				// Vertical Front Porch
	#define VPW				3				// Vertical Pulse Width
	#define DE_POLARITY		LTDC_DEPOLARITY_AH
	#define PC_POLARITY		LTDC_PCPOLARITY_IIPC
#endif

#define HS_POLARITY				LTDC_HSPOLARITY_AL//LTDC_HSPolarity_AL;
#define VS_POLARITY				LTDC_VSPOLARITY_AL//LTDC_VSPolarity_AL;
#define HORIZONTAL_SYNC 		( HPW - 1 )
#define VERTICAL_SYNC			( VPW - 1 )
#define ACCUMULATED_HBP			( HPW + HBP - 1)
#define ACCUMULATED_VBP			( VPW + VBP - 1)
#define ACCUMULATED_ACTIVE_H	( VDP + VPW + VBP - 1 )
#define ACCUMULATED_ACTIVE_W	( HDP + HPW + HBP - 1 )
#define TOTAL_HEIGH				( VBP + VDP + VFP + VPW - 1 )
#define TOTAL_WIDTH				( HBP + HDP + HFP + HPW - 1 )
#define WINDOW_X0				( HORIZONTAL_SYNC + HBP )
#define WINDOW_X1				( WINDOW_X0 + HDP - 1 )
#define WINDOW_Y0				( VERTICAL_SYNC + VBP )
#define WINDOW_Y1				( WINDOW_Y0 + VDP - 1 )
#define PIXEL_FORMAT			LTDC_PIXEL_FORMAT_ARGB8888
#define IMAGE_WIDTH				HDP
#define IMAGE_HEIGHT			VDP

#define LCD_X_PIXEL				((uint16_t)HDP)
#define LCD_Y_PIXEL				((uint16_t)VDP)
#define LCD_TOTAL_PIXEL			LCD_X_PIXEL * LCD_Y_PIXEL
#define LCD_BPP					 		4					//Bytes per pixel. 4 when ARGB8888, 3 when RGB888, 2 when RGB565
#define LCD_BUFFER					LCD_TOTAL_PIXEL * LCD_BPP
#define LCD_START_ADDR			((uint32_t)0xC0000000)
#define LCD_COUNT_LAYER			2
#define LCD_COUNT_BUFFER		2
#define LCD_BUFFER_SIZE			0x200000
#define LCD_END_ADDR				(uint32_t)LCD_START_ADDR+LCD_BUFFER_SIZE*LCD_COUNT_LAYER*LCD_COUNT_BUFFER
#define LCD_BLEND_BUF_START	LCD_END_ADDR
#define LCD_BLEND_BUF_SIZE	LCD_BUFFER_SIZE

#define  RGB565_COL_BLACK          ((uint16_t) 0x0000 )
#define  RGB565_COL_BLUE           ((uint16_t) 0x001F )
#define  RGB565_COL_GREEN          ((uint16_t) 0x07E0 )
#define  RGB565_COL_RED            ((uint16_t) 0xF800 )
#define  RGB565_COL_WHITE          ((uint16_t) 0xFFFF )
#define  RGB565_COL_CYAN           ((uint16_t) 0x07FF )
#define  RGB565_COL_MAGENTA        ((uint16_t) 0xF81F )
#define  RGB565_COL_YELLOW         ((uint16_t) 0xFFE0 )
#define  RGB565_COL_GREY           ((uint16_t) 0x8410 )
#define  RGB565_COL_ORANGE		   ((uint16_t) 0xFC00 )

#define  RGB888_COL_BLACK          ((uint32_t) 0x000000 )
#define  RGB888_COL_BLUE           ((uint32_t) 0x0000FF )
#define  RGB888_COL_GREEN          ((uint32_t) 0x00FF00 )
#define  RGB888_COL_RED            ((uint32_t) 0xFF0000 )
#define  RGB888_COL_WHITE          ((uint32_t) 0xFFFFFF )
#define  RGB888_COL_CYAN           ((uint32_t) 0x00FFFF )
#define  RGB888_COL_MAGENTA        ((uint32_t) 0xFF00FF )
#define  RGB888_COL_YELLOW         ((uint32_t) 0xFFFF00 )
#define  RGB888_COL_GREY           ((uint32_t) 0x808080 )
#define  RGB888_COL_ORANGE		   ((uint32_t) 0xFF8000 )

#define  ARGB8888_COL_BLACK          ((uint32_t) 0xFF000000 )
#define  ARGB8888_COL_BLUE           ((uint32_t) 0xFF0000FF )
#define  ARGB8888_COL_GREEN          ((uint32_t) 0xFF00FF00 )
#define  ARGB8888_COL_RED            ((uint32_t) 0xFFFF0000 )
#define  ARGB8888_COL_WHITE          ((uint32_t) 0xFFFFFFFF )
#define  ARGB8888_COL_CYAN           ((uint32_t) 0xFF00FFFF )
#define  ARGB8888_COL_MAGENTA        ((uint32_t) 0xFFFF00FF )
#define  ARGB8888_COL_YELLOW         ((uint32_t) 0xFFFFFF00 )
#define  ARGB8888_COL_GREY           ((uint32_t) 0xFF808080 )
#define  ARGB8888_COL_ORANGE		 ((uint32_t) 0xFFFF8000 )

#endif /* __GLOBAL_DISPLAY_TOUCH_H_ */
