/***********************************************************
 *
 * d_rigado_bmd_300.h
 * SYSTART GmbH
 * FLB, 09.05.2017
 *
 ***********************************************************/

/***********************************************************
 * Includes
 ***********************************************************/
#include "application/rigado_bmd300.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/***********************************************************
 * Declaration internal functions
 ***********************************************************/
void Rigado_BMD_300_GPIO_init ( void );
void Rigado_BMD_300_SendString ( uint8_t* data );
void Rigado_BMD_300_Delay ( void );
void USART3_IRQHandler(void);

uint8_t status = 0;

/***********************************************************
 * Function definitions
 ***********************************************************/
void Rigado_BMD_300_init( void )
{
	GPIOB -> ODR &= ~GPIO_PIN_15;
	HAL_Delay(500);
	GPIOB -> ODR |= GPIO_PIN_15;

}

void Rigado_BMD_300_SendBytes ( uint32_t count, uint8_t* data )
{
	uart_SendArray(COM3, data, count, BIG_ENDIAN_T);
}

void Rigado_BMD_300_SendByte ( uint8_t data )
{
	uart_SendByte(COM3, data);
}

void Rigado_BMD_300_SendString ( uint8_t* data )
{
	uart_SendString(COM3, data, NONE);
	HAL_Delay(200);
	reset_ringbuffer(COM3);
}

void Rigado_BMD_300_get_string(uint8_t* rx_temp)
{
	uart_ReceiveString(COM3, (char *) rx_temp);
}

RIGADO_STATUS_e Rigado_BMD_300_get_status(void)
{
	if(GPIOB->IDR & GPIO_PIN_13)
	{
		return RIGADO_ACTIVE;
	}
	else
	{
		return RIGADO_INACTIVE;
	}

}

void string_props_init(struct string_props* sp){
	sp->color = 0xFF000000;
	sp->xpos = 50;
	sp->ypos = 100;
}

void process_font_command(struct string_props *sp, char* string){
	char temp_string[50];
	strcpy(temp_string, string);
	char* command = strtok(temp_string, " ");
	if(strcmp(command, "$color") == 0){
		uint32_t red = atoi(strtok(NULL, " "));
		uint32_t green = atoi(strtok(NULL, " "));
		uint32_t blue = atoi(strtok(NULL, " "));

		// store the color in the format: 0xAARRGGBB
		sp->color = 0xFF000000 | (red<<16) | (green<<8) | blue;
		char resp[22];
		sprintf(resp, "New color: #%8lx", sp->color);
		Rigado_BMD_300_SendString((uint8_t*)resp);
	}
	else if(strcmp(command, "$xpos") == 0){
		char* x_pos = strtok(NULL, " ");
		sp->xpos = atoi(x_pos);
		char resp[20] = "New x-Position: ";
		strcat(resp, x_pos);
		Rigado_BMD_300_SendString((uint8_t*)resp);
	}
	else if(strcmp(command, "$ypos") == 0){
		char* y_pos = strtok(NULL, " ");
		sp->ypos = atoi(y_pos);
		char resp[20] = "New y-Position: ";
		strcat(resp, y_pos);
		Rigado_BMD_300_SendString((uint8_t*)resp);
	}
}

