
/*  EBS-SYSTART  [ALL]  2020-06-04 / V100
 *  Example code for using a Adafruit Huzzah 32 Feather on EBS-SYSTART Relay-Board-RDP
 *  Bluetooth acts as virtual COM-connection.
 * 
 *  More information on EBS-SYSTART Relay-Board-RDP:  https://www.ebs-systart.com/relais-board
 *  More Informwetion Adafruit Huzzah32 fether board: https://www.adafruit.com/product/3405
 *  
 *  To use this examle you will need an Arduino IDE with Support for The Huzzah32 installed.
 *  You will also need a PC/Laptop with Blutooth support and Relay-Board Software 
 */

#include "BluetoothSerial.h"

#if !defined(CONFIG_BT_ENABLED) || !defined(CONFIG_BLUEDROID_ENABLED)
  #error Bluetooth is not enabled! Please run `make menuconfig` to and enable it
#endif

BluetoothSerial SerialBT;

void setup() {
  Serial.begin(115200);                 // "USB"-Serial
  Serial1.begin(115200);                // Serial 1 connected to Relay-Board
  SerialBT.begin("Relay-Board-RDP");    // set Bluetooth device name to "Relay-Board-RDP" 
  Serial.println("Started. Pair now!"); // some information on "USB"-Serial
}

void loop() {
  if (Serial1.available()) {            // if new Data recieven from Relay-Board
    SerialBT.write(Serial1.read());     //  send it to PC over bluetooth 
  }
  if (SerialBT.available()) {           // if new data revieved via Bluetooth 
    Serial1.write(SerialBT.read());     //  send it to Relay-Board over UART
  }
  delay(20);                            // some delay for Bluetooth stack etc. 
}
