
/*  EBS-SYSTART  [MIZ]  2020-06-15 / V100
 *  Example code for using a Adafruit Huzzah 32 Feather on EBS-SYSTART Relay-Board-RDP
 *  Huzzah 32 Feather acts as Webserver.
 * 
 *  More information on EBS-SYSTART Relay-Board-RDP:  https://www.ebs-systart.com/relais-board
 *  More Informwetion Adafruit Huzzah32 fether board: https://www.adafruit.com/product/3405
 *  
 *  To use this examle you will need an Arduino IDE with Support for The Huzzah32 installed.
 *  You will also need a PC/Laptop with Wifi support and Relay-Board Software 
 */

#include "WiFi.h"

const char* ssid     = "yourssid";
const char* password = "yourpasswd";

struct inputVariable {
  char in1;
  char in2;
  char in3;
  char in4;
  char in5;
  char in6;
  char in7;
  char in8;
} inputs = {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};

WiFiServer server(80);

void connectToNetwork(void) {
  Serial.print("Connecting to ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
 
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.println(".");
  }
 
  Serial.println("");
  Serial.println("WiFi connected.");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
}

void setup() {
  Serial.begin(115200);
  Serial1.begin(115200);            // Serial 1 connected to Relay-Board
  delay(10);
  
  Serial.println();
  Serial.println();

  connectToNetwork();

  server.begin();
}

void loop() {
  WiFiClient client = server.available();   // listen for incoming clients

  if (client) {                             // if you get a client,
//    Serial.println("New Client.");           // print a message out the serial port
    String currentLine = "";                // make a String to hold incoming data from the client
    while (client.connected()) {            // loop while the client's connected
      if (client.available()) {             // if there's bytes to read from the client,
        char c = client.read();             // read a byte, then
//        Serial.write(c);                    // print it out the serial monitor
        if (c == '\n') {                    // if the byte is a newline character

          // if the current line is blank, you got two newline characters in a row.
          // that's the end of the client HTTP request, so send a response:
          if (currentLine.length() == 0) {
            // HTTP headers always start with a response code (e.g. HTTP/1.1 200 OK)
            // and a content-type so the client knows what's coming, then a blank line:
            client.println("HTTP/1.1 200 OK");
            client.println("Content-type:text/html");
            client.println();

            // the content of the HTTP response follows the header:
            client.print("LED1 <a href=\"/LED1_ON\">einschalten</a> <a href=\"/LED1_OFF\">ausschalten</a><br>");
            client.print("LED2 <a href=\"/LED2_ON\">einschalten</a> <a href=\"/LED2_OFF\">ausschalten</a><br>");
            client.print("LED3 <a href=\"/LED3_ON\">einschalten</a> <a href=\"/LED3_OFF\">ausschalten</a><br><br>");
            
            client.print("RELAY1 <a href=\"/REL1_ON\">einschalten</a> <a href=\"/REL1_OFF\">ausschalten</a><br>");
            client.print("RELAY2 <a href=\"/REL2_ON\">einschalten</a> <a href=\"/REL2_OFF\">ausschalten</a><br>");
            client.print("RELAY3 <a href=\"/REL3_ON\">einschalten</a> <a href=\"/REL3_OFF\">ausschalten</a><br>");
            client.print("RELAY4 <a href=\"/REL4_ON\">einschalten</a> <a href=\"/REL4_OFF\">ausschalten</a><br><br>");
            
            client.print("USB1 <a href=\"/USB1_ON\">einschalten</a> <a href=\"/USB1_OFF\">ausschalten</a><br>");
            client.print("USB2 <a href=\"/USB2_ON\">einschalten</a> <a href=\"/USB2_OFF\">ausschalten</a><br><br>");
            
            client.print("BUS <a href=\"/BUS_ON\">einschalten</a> <a href=\"/BUS_OFF\">ausschalten</a><br><br>");

            client.print("Inputs <a href=\"/INPUT\">refresh</a>:<br>");
            client.print(String("IN1 [") + inputs.in1 + "]; IN2 [" + inputs.in2 + "]; IN3 [" + inputs.in3 + "]; IN4 [" + inputs.in4 + "];<br>");
            client.print(String("IN5 [") + inputs.in5 + "]; IN6 [" + inputs.in6 + "]; IN7 [" + inputs.in7 + "]; IN8 [" + inputs.in8 + "]<br><br>");
            
            client.print("Relay-Board <a href=\"/RST\">resetten</a><br>");
            

            // The HTTP response ends with another blank line:
            client.println();
            // break out of the while loop:
            break;
          } else {    // if you got a newline, then clear currentLine:
            currentLine = "";
          }
        } else if (c != '\r') {  // if you got anything else but a carriage return character,
          currentLine += c;      // add it to the end of the currentLine
        }

        // Check to see the client request
        if (currentLine.endsWith("GET /LED1_ON")) {
          Serial1.print("LED1:1\n");
        }
        else if (currentLine.endsWith("GET /LED1_OFF")) {
          Serial1.print("LED1:0\n");
        }
        else if (currentLine.endsWith("GET /LED2_ON")) {
          Serial1.print("LED2:1\n");
        }
        else if (currentLine.endsWith("GET /LED2_OFF")) {
          Serial1.print("LED2:0\n");
        }
        else if (currentLine.endsWith("GET /LED3_ON")) {
          Serial1.print("LED3:1\n");
        }
        else if (currentLine.endsWith("GET /LED3_OFF")) {
          Serial1.print("LED3:0\n");
        }

        else if (currentLine.endsWith("GET /REL1_ON")) {
          Serial1.print("REL1:1\n");
        }
        else if (currentLine.endsWith("GET /REL1_OFF")) {
          Serial1.print("REL1:0\n");
        }
        else if (currentLine.endsWith("GET /REL2_ON")) {
          Serial1.print("REL2:1\n");
        }
        else if (currentLine.endsWith("GET /REL2_OFF")) {
          Serial1.print("REL2:0\n");
        }
        else if (currentLine.endsWith("GET /REL3_ON")) {
          Serial1.print("REL3:1\n");
        }
        else if (currentLine.endsWith("GET /REL3_OFF")) {
          Serial1.print("REL3:0\n");
        }
        else if (currentLine.endsWith("GET /REL4_ON")) {
          Serial1.print("REL4:1\n");
        }
        else if (currentLine.endsWith("GET /REL4_OFF")) {
          Serial1.print("REL4:0\n");
        }

        else if (currentLine.endsWith("GET /USB1_ON")) {
          Serial1.print("USB1:1\n");
        }
        else if (currentLine.endsWith("GET /USB1_OFF")) {
          Serial1.print("USB1:0\n");
        }
        else if (currentLine.endsWith("GET /USB2_ON")) {
          Serial1.print("USB2:1\n");
        }
        else if (currentLine.endsWith("GET /USB2_OFF")) {
          Serial1.print("USB2:0\n");
        }

        else if (currentLine.endsWith("GET /BUS_ON")) {
          Serial1.print("BUS:1\n");
        }
        else if (currentLine.endsWith("GET /BUS_OFF")) {
          Serial1.print("BUS:0\n");
        }

        else if (currentLine.endsWith("GET /INPUT")) {
          char cBuffer;
          char inputChar;
          Serial1.print("INB?\n");
          while(!Serial1.available());
          while(Serial1.read() != 'b');

          inputs.in8 = Serial1.read();
          inputs.in7 = Serial1.read();
          inputs.in6 = Serial1.read();
          inputs.in5 = Serial1.read();
          inputs.in4 = Serial1.read();
          inputs.in3 = Serial1.read();
          inputs.in2 = Serial1.read();
          inputs.in1 = Serial1.read();
        }

        else if (currentLine.endsWith("GET /RST")) {
          Serial1.print("RST\n");
        }

      }
    }
    // close the connection:
    client.stop();
//    Serial.println("Client Disconnected.");
  }
}
